#include "StdAfx.h"
#include "scriptHeaders.h"
#include "FunctionInstance.h"
#include "list.h"
#include "log.h"
#include "HashTable.h"
#include "Buffer.h"
#include "Interfaces.h"
#include "Manager.h"
#include "script.h"
//***********************************************************************************************************************
//Konstruktor
//***********************************************************************************************************************
CScript::CScript(void)
{
	m_File = NULL;				//nulovani ukazatelu a poctu instanci
	m_VM = NULL;
	m_CurrFunction = NULL;
	m_dwRef = 0;
}
//***********************************************************************************************************************
//Destruktor
//***********************************************************************************************************************
CScript::~CScript(void)
{
	for (unsigned int i = 0; i < m_importedFunctions.Size(); i++)
	{
		ExternFunction* pItem = m_importedFunctions[i];
		FreeLibrary(pItem->hDll);
		Log("Freeing module: %Xh<br>",pItem->hDll);
	}
}
//***********************************************************************************************************************
//fce pro pridani instance
//***********************************************************************************************************************
HRESULT CScript::AddRef()
{
	return m_dwRef++;
}
//***********************************************************************************************************************
//fce pro uvolnnei instance
//***********************************************************************************************************************
HRESULT CScript::Release()
{
	if (m_dwRef > 0)
		m_dwRef--;

	if (m_dwRef == 0)
	{
		delete this;
		return 0;
	}
	else
		return m_dwRef;
}
//***********************************************************************************************************************
//Fce pro precteni znaku
//***********************************************************************************************************************
char	CScript::ReadChar()
{
	char c;
	fread(&c,sizeof(char),1,m_File);
	return c;
}
//***********************************************************************************************************************
//Fce pro precteni retezce ukonceneho nulou
//***********************************************************************************************************************
CBuffer* CScript::ReadZString()
{
	char c;
	CBuffer* cString = new CBuffer;
	do
	{
		fread(&c,sizeof(char),1,m_File);
		if ((int)c != 0)
			*cString += c;
	}
	while ((int)c != 0);

	return cString;
}
//***********************************************************************************************************************
//Fce pro precteni unsigned integeru
//***********************************************************************************************************************
unsigned int CScript::ReadUInt32()
{
	unsigned int c;
	fread(&c,sizeof(unsigned int),1,m_File);
	return c;
}
//***********************************************************************************************************************
//Fce pro precteni integeru 32
//***********************************************************************************************************************
int	CScript::ReadInt32()
{
	int c;
	fread(&c,sizeof(int),1,m_File);
	return c;
}
//***********************************************************************************************************************
//fce pro precteni integeru 16
//***********************************************************************************************************************
short CScript::ReadInt16()
{
	short c;
	fread(&c,sizeof(short),1,m_File);
	return c;
}
//***********************************************************************************************************************
//fce pro precteni bytu
//***********************************************************************************************************************
unsigned char CScript::ReadByte()
{
	unsigned char c;
	fread(&c,sizeof(unsigned char),1,m_File);
	return c;
}
//***********************************************************************************************************************
//Fce pro precteni double
//***********************************************************************************************************************
double CScript::ReadDouble()
{
	double c;
	fread(&c,sizeof(double),1,m_File);
	return c;
}
//***********************************************************************************************************************
//Fce pro precteni unsigned short
//***********************************************************************************************************************
unsigned short CScript::ReadUInt16()
{
	unsigned short c;
	fread(&c,sizeof(unsigned short),1,m_File);
	return c;
}
//***********************************************************************************************************************
//fce pro nacteni skriptu do pameti
//***********************************************************************************************************************
HRESULT CScript::LoadScript(const char* file)
{
	//vytvoreni a inicializace tabulky funkci a importu
	m_ScriptDependencies.m_FunctionList = new CHashTable<char*, FUNCTION_HEADER*>();	//tabulka funkci
	m_ScriptDependencies.m_Imports = new CHashTable<char*,ExternFunction*>();
	
	//docasna promenna pro nacitani znaku
	unsigned char Chr;
	bool bErr = false;

	//otevreni skriptu
	m_File = fopen(file,"rb");
	if (!m_File)		//info o chybe
	{
		Log("Failed to open binary script file %s<br>",file);
		return ERR_BADSTREAM;
	}

	//****************nacteni a kontrola podisu skriptu
	//kazdy skript zkompilovany kompilerem musi mit tneto podpis
	//beyprostredne na zacatku souboru
	char signature[4];
	fread(signature,3*sizeof(char),1,m_File);
	signature[3] = 0;
	if (strcmp(signature,"USL") != 0)
	{
		//pokud podpis skriptu nesouhlasi, nepovazujeme soubor za platny soubor skriptu
		//a koncime s nacitanim. Vratime prislusnou chybu
		Log("Invalid file signature! Cannot continue loading script!<br>");
		return ERR_BADSIGNATURE;
	}
	//podpis je vporadku, vypiseme do logu ze nacitame skript
    Log("Loading script '%s'<br>",file);

	//nacteni skriptu
	do
	{
		Chr = ReadChar();	//precteni cisla sekce

		if (Chr == FUNCTION_ID)		//sekce s definici funkce
		{
			//nic sloziteho, nacitani hodnot do prislusnych vlastnosti
			FUNCTION_HEADER* function = new FUNCTION_HEADER;
			CBuffer*		 functionName = ReadZString();
			function->name = functionName->GetBuffer();
			function->inputs = ReadUInt16();
			function->ouputs = ReadUInt16();
			function->localsLimit = ReadUInt16();
			function->stackLimit = ReadUInt16();
			function->startCode = ReadUInt32();
			function->endCode = ReadUInt32();

			m_ScriptDependencies.m_FunctionList->Put(functionName->GetBuffer(),function);
			m_FunctionTemplates.Add(function);	//pridani sablony do seznamu
			Log("Loaded function '%s'<br>",functionName->GetBuffer());
		}
		else if (Chr == IMPORT_ID)
		{
			ExternFunction* pItem = new ExternFunction;

			char* func_name = ReadZString()->GetBuffer();		//precteni jmena funkce
			char* func_signature = ReadZString()->GetBuffer();	//precteni podpisu funkce
			char* lib_name = ReadZString()->GetBuffer();		//precteni jmena knihovny
			pItem->type = ReadChar();							//precteni typu

			//ziskani handle na knihovnu
			pItem->hDll = GetModuleHandle(lib_name);
			if (!(pItem->hDll))		//pokud se to nepovede, knihovna neni nactena v pametovem prostoru aplikace
			{						//pokusime se handle ziskat tak ze knihovnu nactem
				pItem->hDll = LoadLibrary(lib_name);
				if (!(pItem->hDll))	//pokud se nam nepodari ziskat handle knihovny ani jejim nactenim
				{						//tak informujeme o chybe, ale nebudeme to brat jako chybu kvuli ktere
					Log("Failed to get handle of module '%s'.<br>",lib_name);  //by skript nemohl byt spusten
					bErr = true;
				}
			}
			//pokud je handle knihovny platne
			if (pItem->hDll)
			{
				//ziskani adresy funkce
				pItem->address = GetProcAddress(pItem->hDll,func_name);
				if (!(pItem->address))
					Log("Failed to retrieve adress of function '%s'<br>",func_name);
			}

			//pridani funkce do hashovaci tabulky
			m_ScriptDependencies.m_Imports->Put(func_signature,pItem);
			m_importedFunctions.Add(pItem);

			//vypsani informace do logu
			Log("Loaded external function '%s' (Address: %Xh), Library: '%s' (Handle: %Xh).<br>",func_name,pItem->address,lib_name,pItem->hDll);
		}
		else if (Chr == CONSTANTS_ID)	//sekce s tabulkou konstant
		{
			m_ScriptDependencies.m_NumConstants = ReadUInt32();
			Log("Loading Constant Table. Total constants: %i<br>",m_ScriptDependencies.m_NumConstants);

			m_ScriptDependencies.m_ConstantTable.Init(m_ScriptDependencies.m_NumConstants);	//tabulka konstant

			//v cyklu nacteme konstanty
			for (unsigned int i = 0; i < m_ScriptDependencies.m_NumConstants; i++)
			{
				char type = ReadChar();	//precti typ konstanty

				switch (type)
				{
				case INT_CONST:
					m_ScriptDependencies.m_ConstantTable[i].kind = INT_CONST;
					m_ScriptDependencies.m_ConstantTable[i].intval = ReadInt32();
					Log("Read constant integer: %i<br>",m_ScriptDependencies.m_ConstantTable[i].intval);
					break;
				case ZSTRING_CONST:
					m_ScriptDependencies.m_ConstantTable[i].kind = ZSTRING_CONST;
					m_ScriptDependencies.m_ConstantTable[i].strval = ReadZString()->GetBuffer();
					Log("Read constant string: %s<br>",m_ScriptDependencies.m_ConstantTable[i].strval);
					break;
				case DOUBLE_CONST:
					m_ScriptDependencies.m_ConstantTable[i].kind = DOUBLE_CONST;
					m_ScriptDependencies.m_ConstantTable[i].doubleval = ReadDouble();
					Log("Read constant double: %f<br>",m_ScriptDependencies.m_ConstantTable[i].doubleval);
					break;
				default:
					Log("ERROR - Unknown constant type '%i'<br>",type);
					break;
				}
			}
		}
		else if (Chr == CODE_ID)		//kodovy segment
		{
			m_ScriptDependencies.m_CodeSegmentSize = ReadUInt32();	//precteni velikosti kodoveho segmentu

			//alokace pameti pro nacteni kodoveho segmentu
			m_ScriptDependencies.m_CodeSegment = new unsigned char[m_ScriptDependencies.m_CodeSegmentSize];
			Log("Loading code. Code size: %i bytes<br>",m_ScriptDependencies.m_CodeSegmentSize);

			fread(m_ScriptDependencies.m_CodeSegment,sizeof(unsigned char),m_ScriptDependencies.m_CodeSegmentSize,m_File);
		}
	}
	while (m_ScriptDependencies.m_CodeSegment == NULL);		//opakuj dokud neni platny ukazatel na kodovy segment, tj dokud neni kodovy segment nacten

	//zavreni souboru
	fclose(m_File);

	//skript je nacten, ted ho musime na necem spustit, ziskej proto ukazatel na royhrani virtualniho stroje
	//abzchom mohli skript spustit
	CreateVMObject(IID_IVirtualMachine,(void**)&m_VM);
	if (!m_VM)
	{
		//pokud se to nepovede, je to blby
		Log("Failed to obtain pointer to Virtual machine interface! Null Pointer!<br>");
		return E_NOINTERFACE;
	}

	//inicializuje virtualni stroj
	m_VM->Init(&m_ScriptDependencies);

	//spust funkci main pokud ve skriptu je
	StartMain();

	//vrat Ok
	return S_OK;
}
//***********************************************************************************************************************
//Fce pro spusteni funkce main
//***********************************************************************************************************************
HRESULT	CScript::StartMain()
{
	for (unsigned int i = 0; i < m_FunctionTemplates.Size(); i++)
	{
		FUNCTION_HEADER* tmp = m_FunctionTemplates[i];
		if (strncmp(tmp->name,"main",4) == 0)						//projdi v cyklu vsechny nactene funkce a pokud 
		{															//prvni ctyri pismena nayvu funkce souhlasi
			CFunctionInstance* instance = MakeInstance(tmp);		//s main, tak ji spust a skonci
			m_runningFunctions.Add(instance);
			m_CurrFunction = instance;
			return S_OK;
		}
	}

	return S_FALSE;
}
//***********************************************************************************************************************
//Fce pro spusteni libovolne funkce
//***********************************************************************************************************************
HRESULT	CScript::RunFunction(char* function)
{
	for (unsigned int i = 0; i < m_FunctionTemplates.Size(); i++)
	{
		FUNCTION_HEADER* tmp = m_FunctionTemplates[i];
		if (strncmp(tmp->name,function,strlen(function)) == 0)		//projdi v cyklu vsechny nactene funkce a pokud 
		{															//prvni pismena souhlasi s nazvem funkce
			CFunctionInstance* instance = MakeInstance(tmp);		//tak ji spust a skonci
			m_runningFunctions.Add(instance);
			m_CurrFunction = instance;
			return S_OK;
		}
	}

	return S_FALSE;
}
//***********************************************************************************************************************
//Funkce pro yastaveni vsech bezicih funkci
//***********************************************************************************************************************
void	CScript::Stop()
{
	m_runningFunctions.Clear();		//staci vycistit seznam bezicich funkci
}

//***********************************************************************************************************************
//vytvori instanci funkce
//***********************************************************************************************************************
CFunctionInstance*	CScript::MakeInstance(FUNCTION_HEADER* function)
{
	CFunctionInstance* newInstance = new CFunctionInstance;

	newInstance->function = function;
	newInstance->SetEndCode(function->endCode);
	newInstance->SetPC(function->startCode);
	newInstance->SetSP(function->localsLimit - 1);
	newInstance->SetBSP(0);
	newInstance->SetNumberOfParams(function->inputs);
	//nastav fci ktera se provedep pri zmene zasobniku

	return newInstance;
}
//***********************************************************************************************************************
//Fce pro obslouzeni skriptu
//provede se maximalne iMaxInstructions instrukci.
//Bude obslouzena vzdy jedna funkce ze seznamu spustenych funkci
//do promenne na kterou ukazuje isnext se ulozi true pokud je v seznamu dalsi funkce k obslouzeni
//***********************************************************************************************************************
void CScript::HandleScripts(int iMaxInstructions,bool* isnext)
{
	static unsigned int i = 0;

	//pokud je v seznamu bezicich funkci nejaka funkce k obslouzeni
	if (i < m_runningFunctions.Size())
	{
		m_CurrFunction = m_runningFunctions[i];

		if (m_CurrFunction->status == STATUS_RUNNING)	//proved zadany pocet instrukci na funkci
			m_VM->Run(m_CurrFunction,iMaxInstructions);

		if (m_CurrFunction->status == STATUS_DEAD)		//pokud byla funkce ukoncena, tj ma status dead
		{												//tak ji odstran ze seznamu bezicich funkci.
			m_runningFunctions.Remove(m_CurrFunction);
			m_CurrFunction = NULL;
		}

		if (isnext)						//pokud je ukzatel platny
			*isnext = true;				//uloz true, v seznamu je dalsi funkce ke zpracovani
		i++;							//inkrementuj i, tj. posun se na dalsi funkci
	}
	else
	{
		if (isnext)
			*isnext = false;			//uloz false, v senamu uz neni dalsi funkce k provedeni
		i = 0;							//i bude ukazovat opet na prvni funkci
	}
}
